/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.gui;

import galaxyspace.core.client.gui.tile.GuiTileBase;
import galaxyspace.systems.SolarSystem.planets.overworld.inventory.ContainerWindGenerator;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityWindGenerator;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;

public class GuiWindGenerator
extends GuiTileBase {
    private final TileEntityWindGenerator tileEntity;
    private GuiButton buttonEnableSolar;

    public GuiWindGenerator(InventoryPlayer par1InventoryPlayer, TileEntityWindGenerator tileEntity) {
        super(new ContainerWindGenerator(par1InventoryPlayer, tileEntity), 2, 1);
        this.tileEntity = tileEntity;
        this.field_147000_g = 201;
        this.header = -1;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ArrayList<String> sunGenDesc = new ArrayList<String>();
        sunGenDesc.add(this.tileEntity.getWindBoost() > 0.0f ? GCCoreUtil.translate((String)"gui.status.wind.name") : GCCoreUtil.translate((String)"gui.status.nowind.name"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 16, (this.field_146295_m - this.field_147000_g) / 2 + 20, 18, 18, sunGenDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this));
        this.buttonEnableSolar = new GuiButton(0, this.field_146294_l / 2 - 36, this.field_146295_m / 2 - 19, 72, 20, GCCoreUtil.translate((String)"gui.button.enable.name"));
        this.field_146292_n.add(this.buttonEnableSolar);
        ArrayList<String> rotorDesc = new ArrayList<String>();
        rotorDesc.add(GCCoreUtil.translate((String)"gui.rotor_slot_desc.0"));
        rotorDesc.add(GCCoreUtil.translate((String)"gui.rotor_slot_desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + this.field_147002_h.func_75139_a((int)1).field_75223_e, (this.field_146295_m - this.field_147000_g) / 2 + this.field_147002_h.func_75139_a((int)1).field_75221_f, 18, 18, rotorDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this));
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        int offsetY = 35;
        this.buttonEnableSolar.field_146124_l = this.tileEntity.disableCooldown == 0;
        this.buttonEnableSolar.field_146126_j = !this.tileEntity.getDisabled(0) ? GCCoreUtil.translate((String)"gui.button.disable.name") : GCCoreUtil.translate((String)"gui.button.enable.name");
        TextFormatting color = this.getStyle() == GuiTileBase.Style.MODERN ? TextFormatting.WHITE : TextFormatting.DARK_GRAY;
        String displayString = GCCoreUtil.translate((String)"gui.message.status.name") + ": " + this.getStatus();
        this.field_146289_q.func_78276_b(color + displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 22 + offsetY, 0x404040);
        displayString = GCCoreUtil.translate((String)"gui.message.generating.name") + ": " + (this.tileEntity.generateWatts > 0.0f ? EnergyDisplayHelper.getEnergyDisplayS((float)this.tileEntity.generateWatts) + "/t" : GCCoreUtil.translate((String)"gui.status.not_generating.name"));
        this.field_146289_q.func_78276_b(color + displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 11 + offsetY, 0x404040);
        float boost = (float)Math.round((this.tileEntity.getWindBoost() - 1.0f) * 1000.0f) / 10.0f;
        if (boost < 100.0f) {
            boost = -100.0f;
        }
        displayString = GCCoreUtil.translate((String)"gui.message.environment.name") + ": " + boost + "%";
        this.field_146289_q.func_78276_b(color + displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 33 + offsetY, 0x404040);
    }

    private String getStatus() {
        if (this.tileEntity.getDisabled(0)) {
            return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.disabled.name");
        }
        if (this.tileEntity.generateWatts > 0.0f) {
            return EnumColor.DARK_GREEN + GCCoreUtil.translate((String)"gui.status.collectingenergy.name");
        }
        if ((double)this.tileEntity.getWindBoost() < 0.1) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.nowind.name");
        }
        return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.unknown.name");
    }

    @Override
    protected void func_146976_a(float var1, int var2, int var3) {
        super.func_146976_a(var1, var2, var3);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
        int containerWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int containerHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.renderEnergyBar(containerWidth + 55, containerHeight + 25, (int)Math.floor(this.tileEntity.getEnergyStoredGC() * 54.0f / this.tileEntity.getMaxEnergyStoredGC()), this.tileEntity.getEnergyStoredGC(), this.tileEntity.getMaxEnergyStoredGC());
        this.func_73729_b(containerWidth + 15, containerHeight + 19, 180, 175, 22, 22);
        if (this.tileEntity.getWindBoost() < 0.1f) {
            GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
        }
        this.func_73729_b(containerWidth + 15, containerHeight + 19, 202, 175, 22, 22);
    }

    @Override
    protected boolean isModuleSupport() {
        return false;
    }

    @Override
    protected String getName() {
        return this.tileEntity.func_70005_c_();
    }

    @Override
    protected Slot getBatterySlot() {
        return this.field_147002_h.func_75147_a((IInventory)this.tileEntity, 0);
    }
}

