/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.capability.impl;

import io.github.phantamanta44.libnine.component.reservoir.FluidReservoir;
import io.github.phantamanta44.libnine.util.data.ByteUtils;
import io.github.phantamanta44.libnine.util.data.ISerializable;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class L9AspectFluidHandler
implements IFluidHandler,
ISerializable {
    private final boolean overflowProtection;
    private final FluidReservoir[] tanks;

    public L9AspectFluidHandler(boolean overflowProtection, FluidReservoir ... tanks) {
        this.overflowProtection = overflowProtection;
        this.tanks = tanks;
    }

    public L9AspectFluidHandler(boolean overflowProtection, int tankCount, Supplier<FluidReservoir> tankFactory) {
        this(overflowProtection, (FluidReservoir[])IntStream.range(0, tankCount).mapToObj(i -> (FluidReservoir)tankFactory.get()).toArray(FluidReservoir[]::new));
    }

    public FluidReservoir[] getTanks() {
        return this.tanks;
    }

    public IFluidTankProperties[] getTankProperties() {
        IFluidTankProperties[] props = new IFluidTankProperties[this.tanks.length];
        for (int i = 0; i < this.tanks.length; ++i) {
            props[i] = new FluidTankProperties(this.tanks[i].getFluid(), this.tanks[i].getCapacity());
        }
        return props;
    }

    public int fill(FluidStack resource, boolean doFill) {
        int maxFill = resource.amount;
        resource = resource.copy();
        for (FluidReservoir tank : this.tanks) {
            if (!tank.canFillFluidType(resource)) continue;
            int amount = tank.fill(resource, doFill);
            if (amount > 0 && this.overflowProtection) {
                return amount;
            }
            resource.amount -= amount;
            if (resource.amount > 0) continue;
            return maxFill;
        }
        return maxFill - resource.amount;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource.amount <= 0) {
            return null;
        }
        int drainRemaining = resource.amount;
        for (FluidReservoir tank : this.tanks) {
            FluidStack drained;
            if (!tank.canDrainFluidType(resource) || !tank.hasFluid() || (drained = tank.drain(drainRemaining, doDrain)) == null || (drainRemaining -= drained.amount) > 0) continue;
            return resource.copy();
        }
        if (drainRemaining >= resource.amount) {
            return null;
        }
        resource = resource.copy();
        resource.amount -= drainRemaining;
        return resource;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        for (FluidReservoir tank : this.tanks) {
            FluidStack drained;
            if (!tank.hasFluid() || (drained = tank.drain(maxDrain, doDrain)) == null) continue;
            return drained;
        }
        return null;
    }

    @Override
    public void serNBT(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (FluidReservoir tank : this.tanks) {
            NBTTagCompound tankTag = new NBTTagCompound();
            tank.serNBT(tankTag);
            list.func_74742_a((NBTBase)tankTag);
        }
        tag.func_74782_a("Tanks", (NBTBase)list);
    }

    @Override
    public void deserNBT(NBTTagCompound tag) {
        NBTTagList list = tag.func_150295_c("Tanks", 10);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].deserNBT(list.func_150305_b(i));
        }
    }

    @Override
    public void serBytes(ByteUtils.Writer data) {
        for (FluidReservoir tank : this.tanks) {
            tank.serBytes(data);
        }
    }

    @Override
    public void deserBytes(ByteUtils.Reader data) {
        for (FluidReservoir tank : this.tanks) {
            tank.deserBytes(data);
        }
    }
}

