/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.types;

import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import me.lucko.luckperms.common.calculator.processor.WildcardProcessor;
import me.lucko.luckperms.common.node.AbstractNode;
import me.lucko.luckperms.common.node.AbstractNodeBuilder;
import me.lucko.luckperms.common.node.factory.NodeBuilders;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.node.NodeBuilder;
import net.luckperms.api.node.metadata.NodeMetadataKey;
import net.luckperms.api.node.types.PermissionNode;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Permission
extends AbstractNode<PermissionNode, PermissionNode.Builder>
implements PermissionNode {
    private final int wildcardLevel;

    public static Builder builder() {
        return new Builder();
    }

    public Permission(String permission, boolean value, long expireAt, ImmutableContextSet contexts, Map<NodeMetadataKey<?>, Object> metadata) {
        super(permission, value, expireAt, contexts, metadata);
        this.wildcardLevel = WildcardProcessor.isWildcardPermission(permission) ? permission.chars().filter(num -> num == 46).sum() : -1;
    }

    @Override
    public @NonNull String getPermission() {
        return this.getKey();
    }

    @Override
    public boolean isWildcard() {
        return this.wildcardLevel != -1;
    }

    @Override
    public @NonNull OptionalInt getWildcardLevel() {
        return this.isWildcard() ? OptionalInt.of(this.wildcardLevel) : OptionalInt.empty();
    }

    @Override
    public @NonNull PermissionNode.Builder toBuilder() {
        return new Builder(this.key, this.value, this.expireAt, this.contexts, this.metadata);
    }

    public static final class Builder
    extends AbstractNodeBuilder<PermissionNode, PermissionNode.Builder>
    implements PermissionNode.Builder {
        private String permission;

        private Builder() {
            this.permission = null;
        }

        public Builder(String permission, boolean value, long expireAt, ImmutableContextSet context, Map<NodeMetadataKey<?>, Object> metadata) {
            super(value, expireAt, context, metadata);
            this.permission = permission;
        }

        @Override
        public @NonNull Builder permission(@NonNull String permission) {
            this.permission = Objects.requireNonNull(permission, "permission");
            return this;
        }

        @Override
        public @NonNull Permission build() {
            Objects.requireNonNull(this.permission, "permission");
            NodeBuilder<?, ?> testBuilder = NodeBuilders.determineMostApplicable(this.permission);
            if (!(testBuilder instanceof Builder)) {
                throw new IllegalArgumentException("Attempting to build non-permission node with PermissionNode.Builder. permission = '" + this.permission + "', correct builder type = " + testBuilder.getClass().getName());
            }
            return new Permission(this.permission, this.value, this.expireAt, this.context.build(), this.metadata);
        }
    }
}

