/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.config;

import com.google.common.reflect.TypeToken;
import io.github.aquerr.eaglefactions.api.config.ChatConfig;
import io.github.aquerr.eaglefactions.api.config.Configuration;
import io.github.aquerr.eaglefactions.api.config.DynmapConfig;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.config.PVPLoggerConfig;
import io.github.aquerr.eaglefactions.api.config.PowerConfig;
import io.github.aquerr.eaglefactions.api.config.ProtectionConfig;
import io.github.aquerr.eaglefactions.api.config.StorageConfig;
import io.github.aquerr.eaglefactions.common.config.ChatConfigImpl;
import io.github.aquerr.eaglefactions.common.config.DynmapConfigImpl;
import io.github.aquerr.eaglefactions.common.config.FactionsConfigImpl;
import io.github.aquerr.eaglefactions.common.config.PVPLoggerConfigImpl;
import io.github.aquerr.eaglefactions.common.config.PowerConfigImpl;
import io.github.aquerr.eaglefactions.common.config.ProtectionConfigImpl;
import io.github.aquerr.eaglefactions.common.config.StorageConfigImpl;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.asset.Asset;

public class ConfigurationImpl
implements Configuration {
    private Path configDirectoryPath;
    private Path configPath;
    private ConfigurationLoader<CommentedConfigurationNode> configLoader;
    private CommentedConfigurationNode configNode;
    private final StorageConfig storageConfig;
    private final ChatConfig chatConfig;
    private final DynmapConfig dynmapConfig;
    private final PowerConfig powerConfig;
    private final ProtectionConfig protectionConfig;
    private final PVPLoggerConfig pvpLoggerConfig;
    private final FactionsConfig factionsConfig;

    public ConfigurationImpl(Path configDir, Asset configAsset) {
        this.configDirectoryPath = configDir;
        if (!Files.exists(this.configDirectoryPath, new LinkOption[0])) {
            try {
                Files.createDirectory(this.configDirectoryPath, new FileAttribute[0]);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        this.configPath = this.configDirectoryPath.resolve("Settings.conf");
        try {
            configAsset.copyToFile(this.configPath, false, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.configLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.configPath)).build();
        this.loadConfiguration();
        this.storageConfig = new StorageConfigImpl(this);
        this.chatConfig = new ChatConfigImpl(this);
        this.dynmapConfig = new DynmapConfigImpl(this);
        this.powerConfig = new PowerConfigImpl(this);
        this.protectionConfig = new ProtectionConfigImpl(this);
        this.pvpLoggerConfig = new PVPLoggerConfigImpl(this);
        this.factionsConfig = new FactionsConfigImpl(this);
        this.reloadConfiguration();
    }

    @Override
    public FactionsConfig getFactionsConfig() {
        return this.factionsConfig;
    }

    @Override
    public Path getConfigDirectoryPath() {
        return this.configDirectoryPath;
    }

    @Override
    public Path getConfigPath() {
        return this.configPath;
    }

    @Override
    public ChatConfig getChatConfig() {
        return this.chatConfig;
    }

    @Override
    public DynmapConfig getDynmapConfig() {
        return this.dynmapConfig;
    }

    @Override
    public StorageConfig getStorageConfig() {
        return this.storageConfig;
    }

    @Override
    public PowerConfig getPowerConfig() {
        return this.powerConfig;
    }

    @Override
    public ProtectionConfig getProtectionConfig() {
        return this.protectionConfig;
    }

    @Override
    public PVPLoggerConfig getPvpLoggerConfig() {
        return this.pvpLoggerConfig;
    }

    @Override
    public void reloadConfiguration() {
        this.loadConfiguration();
        this.storageConfig.reload();
        this.chatConfig.reload();
        this.dynmapConfig.reload();
        this.powerConfig.reload();
        this.protectionConfig.reload();
        this.pvpLoggerConfig.reload();
        this.factionsConfig.reload();
    }

    private void loadConfiguration() {
        try {
            this.configNode = (CommentedConfigurationNode)this.configLoader.load(ConfigurationOptions.defaults().setShouldCopyDefaults(true));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void save() {
        try {
            this.configLoader.save((ConfigurationNode)this.configNode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getInt(int defaultValue, Object ... nodePath) {
        return this.configNode.getNode(nodePath).getInt(defaultValue);
    }

    @Override
    public double getDouble(double defaultValue, Object ... nodePath) {
        Object value = this.configNode.getNode(nodePath).getValue((Object)defaultValue);
        if (value instanceof Integer) {
            int number = (Integer)value;
            return number;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        return 0.0;
    }

    @Override
    public float getFloat(float defaultValue, Object ... nodePath) {
        return this.configNode.getNode(nodePath).getFloat(defaultValue);
    }

    @Override
    public boolean getBoolean(boolean defaultValue, Object ... nodePath) {
        return this.configNode.getNode(nodePath).getBoolean(defaultValue);
    }

    @Override
    public String getString(String defaultValue, Object ... nodePath) {
        return this.configNode.getNode(nodePath).getString(defaultValue);
    }

    @Override
    public List<String> getListOfStrings(Collection<String> defaultValue, Object ... nodePath) {
        try {
            return this.configNode.getNode(nodePath).getList(TypeToken.of(String.class), new ArrayList<String>(defaultValue));
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    @Override
    public Set<String> getSetOfStrings(Collection<String> defaultValue, Object ... nodePath) {
        try {
            return new HashSet<String>(this.configNode.getNode(nodePath).getList(TypeToken.of(String.class), new ArrayList<String>(defaultValue)));
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
            return new HashSet<String>();
        }
    }
}

