/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.handler;

import asmodeuscore.core.astronomy.BodiesData;
import asmodeuscore.core.astronomy.BodiesRegistry;
import asmodeuscore.core.astronomy.gui.screen.AC_GuiCelestialSelection;
import asmodeuscore.core.astronomy.gui.screen.NewGuiCelestialSelection;
import asmodeuscore.core.proxy.ClientProxy;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class GalaxyMapHandler {
    private static final ResourceLocation saturnRingTexture = new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/saturn_rings.png");
    private static final ResourceLocation uranusRingTexture = new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/uranus_rings.png");
    final Minecraft minecraft = FMLClientHandler.instance().getClient();
    public Random rand;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRingRender(CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre renderEvent) {
        if (renderEvent.celestialBody.getRingColorR() == 1.1f && renderEvent.celestialBody.getRingColorG() == 0.0f && renderEvent.celestialBody.getRingColorB() == 0.0f) {
            this.RingRender(renderEvent, renderEvent.celestialBody, 0.7f, 0.0f, 0.0f);
        }
        if (renderEvent.celestialBody.getRingColorG() == 1.1f && renderEvent.celestialBody.getRingColorB() == 0.0f && renderEvent.celestialBody.getRingColorR() == 0.0f) {
            this.RingRender(renderEvent, renderEvent.celestialBody, 0.0f, 0.7f, 0.0f);
        }
        if (renderEvent.celestialBody.getRingColorB() == 1.1f && renderEvent.celestialBody.getRingColorG() == 0.0f && renderEvent.celestialBody.getRingColorR() == 0.0f) {
            this.RingRender(renderEvent, renderEvent.celestialBody, 0.0f, 0.0f, 0.7f);
        }
        if (renderEvent.celestialBody.getRingColorR() == 0.0f && renderEvent.celestialBody.getRingColorG() == 0.0f && renderEvent.celestialBody.getRingColorB() == 0.0f) {
            this.RingRenderNull(renderEvent, renderEvent.celestialBody);
        }
        if (renderEvent.celestialBody instanceof Star && ClientProxy.renderHabitable) {
            this.RingRenderHabitableZone(renderEvent);
        }
    }

    public void RingRenderNull(CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre renderEvent, CelestialBody aroundBody) {
        renderEvent.setCanceled(true);
    }

    public void RingRenderHabitableZone(CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre renderEvent) {
        float temp;
        int i;
        BodiesData data = BodiesRegistry.getData(renderEvent.celestialBody);
        if (data == null) {
            return;
        }
        Vector3f mapPos = renderEvent.parentOffset;
        float xOffset = mapPos.x;
        float yOffset = mapPos.y;
        float sum = data.getStarHZoneDistance() - data.getStarHZoneSize();
        renderEvent.setCanceled(true);
        float theta = 0.06981317f;
        float cos = (float)Math.cos(0.06981316953897476);
        float sin = (float)Math.sin(0.06981316953897476);
        float min = 72.0f;
        float max = 78.0f;
        float x = max * (data.getStarHZoneDistance() + data.getStarHZoneSize());
        float y = 0.0f;
        GL11.glColor4f((float)0.0f, (float)0.7f, (float)0.0f, (float)0.5f);
        GL11.glBegin((int)2);
        for (i = 0; i < 90; ++i) {
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
        }
        GL11.glEnd();
        GL11.glBegin((int)2);
        x = min * (data.getStarHZoneDistance() - data.getStarHZoneSize());
        y = 0.0f;
        for (i = 0; i < 90; ++i) {
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
        }
        GL11.glEnd();
        GL11.glColor4f((float)0.0f, (float)0.7f, (float)0.0f, (float)0.1f);
        GL11.glBegin((int)7);
        x = min * (data.getStarHZoneDistance() - data.getStarHZoneSize());
        y = 0.0f;
        float x2 = max * (data.getStarHZoneDistance() + data.getStarHZoneSize());
        float y2 = 0.0f;
        for (int i2 = 0; i2 < 90; ++i2) {
            GL11.glVertex2f((float)(x2 + xOffset), (float)(y2 + yOffset));
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
            temp = x2;
            x2 = cos * x2 - sin * y2;
            y2 = sin * temp + cos * y2;
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            GL11.glVertex2f((float)(x2 + xOffset), (float)(y2 + yOffset));
        }
        GL11.glEnd();
    }

    public void RingRender(CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre renderEvent, CelestialBody aroundBody, float par1, float par2, float par3) {
        float temp;
        int i;
        Vector3f mapPos = renderEvent.parentOffset;
        float sum = renderEvent.celestialBody.getRelativeDistanceFromCenter().unScaledDistance - renderEvent.celestialBody.getRelativeDistanceFromCenter().scaledDistance;
        float xOffset = mapPos.x;
        float yOffset = mapPos.y;
        if (FMLClientHandler.instance().getClient().field_71462_r instanceof AC_GuiCelestialSelection || FMLClientHandler.instance().getClient().field_71462_r instanceof NewGuiCelestialSelection) {
            GL11.glColor4f((float)par1, (float)par2, (float)par3, (float)0.5f);
        } else {
            GL11.glColor4f((float)0.3f, (float)0.1f, (float)0.1f, (float)0.0f);
        }
        renderEvent.setCanceled(true);
        float theta = 0.06981317f;
        float cos = (float)Math.cos(0.06981316953897476);
        float sin = (float)Math.sin(0.06981316953897476);
        float min = 72.0f;
        float max = 78.0f;
        if (aroundBody instanceof Planet) {
            min = 72.0f;
            max = 78.0f;
        } else if (aroundBody instanceof Moon) {
            max = 0.6666667f;
            min = 0.5263158f;
        }
        float x = max * (renderEvent.celestialBody.getRelativeDistanceFromCenter().unScaledDistance + sum);
        float y = 0.0f;
        GL11.glBegin((int)2);
        for (i = 0; i < 90; ++i) {
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
        }
        GL11.glEnd();
        GL11.glBegin((int)2);
        x = min * (renderEvent.celestialBody.getRelativeDistanceFromCenter().unScaledDistance - sum);
        y = 0.0f;
        for (i = 0; i < 90; ++i) {
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
        }
        GL11.glEnd();
        GL11.glColor4f((float)par1, (float)par2, (float)par3, (float)0.1f);
        GL11.glBegin((int)7);
        x = min * (renderEvent.celestialBody.getRelativeDistanceFromCenter().unScaledDistance - sum);
        y = 0.0f;
        float x2 = max * (renderEvent.celestialBody.getRelativeDistanceFromCenter().unScaledDistance + sum);
        float y2 = 0.0f;
        for (int i2 = 0; i2 < 90; ++i2) {
            GL11.glVertex2f((float)(x2 + xOffset), (float)(y2 + yOffset));
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
            temp = x2;
            x2 = cos * x2 - sin * y2;
            y2 = sin * temp + cos * y2;
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            GL11.glVertex2f((float)(x2 + xOffset), (float)(y2 + yOffset));
        }
        GL11.glEnd();
    }
}

