/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.utils;

import asmodeuscore.core.utils.worldengine2.world.biome.WE_Biome;
import asmodeuscore.core.utils.worldengine2.world.properties.WE_BiomeProperties;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

public class Utils {
    public static Biome WE_Biome = new asmodeuscore.core.utils.worldengine.WE_Biome(new Biome.BiomeProperties("-=|WorldEngine|=-").func_185398_c(1.2f));
    public static Biome WE_Biome_2 = new WE_Biome(new WE_BiomeProperties());
    public static TextureAtlasSprite missingIcon;
    private static TextureMap texMap;

    public static void initFluidTextures(TextureMap map) {
        missingIcon = map.func_174944_f();
        texMap = map;
    }

    public static boolean inWater(EntityPlayer player) {
        BlockPos pos = player.func_180425_c();
        return player.field_70170_p.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151586_h;
    }

    public static TextureAtlasSprite getBlockTexture(Block block) {
        return Utils.getBlockTexture(block, "");
    }

    public static TextureAtlasSprite getBlockTexture(Block block, String addpath) {
        if (block == null) {
            return missingIcon;
        }
        ResourceLocation spriteLocation = block.getRegistryName();
        TextureAtlasSprite sprite = texMap.func_110572_b(spriteLocation.func_110624_b() + ":blocks/" + spriteLocation.func_110623_a() + addpath);
        return sprite != null ? sprite : missingIcon;
    }

    public static TextureAtlasSprite getFluidTexture(Fluid fluid, FluidType type) {
        if (fluid == null || type == null) {
            return missingIcon;
        }
        ResourceLocation spriteLocation = type == FluidType.STILL ? fluid.getStill() : fluid.getFlowing();
        TextureAtlasSprite sprite = texMap.getTextureExtry(spriteLocation.toString());
        return sprite != null ? sprite : missingIcon;
    }

    public static void drawFluid(int xPos, int yPos, int scale, FluidStack fluid) {
        int renderRemaining;
        if (fluid == null) {
            return;
        }
        int guiWidth = 0;
        int guiHeight = 0;
        int start = 0;
        do {
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            Utils.drawTexturedModalRect(guiWidth + xPos, guiHeight + yPos + 58 - renderRemaining - start, Utils.getFluidTexture(fluid.getFluid(), FluidType.STILL), 16, 16 - (16 - renderRemaining));
            start += 16;
        } while (renderRemaining != 0 && scale != 0);
    }

    public static void drawTexturedModalRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        double zLevel = 0.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + heightIn), zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + 0), zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + 0), zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRect(float x, float y, float width, float height, float u, float v, float uWidth, float vHeight, boolean invertX, boolean invertY, float texSizeX, float texSizeY) {
        float zLevel = 0.0f;
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        float texModX = 1.0f / texSizeX;
        float texModY = 1.0f / texSizeY;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float height0 = invertY ? 0.0f : vHeight;
        float height1 = invertY ? vHeight : 0.0f;
        float width0 = invertX ? uWidth : 0.0f;
        float width1 = invertX ? 0.0f : uWidth;
        worldRenderer.func_181662_b((double)x, (double)(y + height), (double)zLevel).func_187315_a((double)((u + width0) * texModX), (double)((v + height0) * texModY)).func_181675_d();
        worldRenderer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)((u + width1) * texModX), (double)((v + height0) * texModY)).func_181675_d();
        worldRenderer.func_181662_b((double)(x + width), (double)y, (double)zLevel).func_187315_a((double)((u + width1) * texModX), (double)((v + height1) * texModY)).func_181675_d();
        worldRenderer.func_181662_b((double)x, (double)y, (double)zLevel).func_187315_a((double)((u + width0) * texModX), (double)((v + height1) * texModY)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static int getIntColor(int r, int g, int b) {
        return Utils.getIntColor(r, g, b, 255);
    }

    public static int getIntColorWHC(int r, int g, int b, int a) {
        return Utils.getIntColor(r, g, b, a) + 0x1000000;
    }

    public static int getIntColor(int r, int g, int b, int a) {
        int A = a * 256 * 256 * 256;
        int R = r * 256 * 256;
        int G = g * 256;
        int B = b;
        int color = A + R + G + B;
        return color - 0x1000000;
    }

    public static float calculateCelestialAngle(long worldtime, float ticks, float daylenght) {
        int j = (int)((float)worldtime % daylenght);
        float f1 = ((float)j + ticks) / daylenght - 0.25f;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        if (f1 > 1.0f) {
            f1 -= 1.0f;
        }
        float f2 = f1;
        f1 = 1.0f - (float)((Math.cos((double)f1 * Math.PI) + 1.0) / 2.0);
        f1 = f2 + (f1 - f2) / 3.0f;
        return f1;
    }

    public static float interpolateRotation(float a1, float a2, float p) {
        float angle = a2 - a1;
        angle = angle < -180.0f ? (angle = angle + 360.0f) : angle;
        angle = angle >= 180.0f ? (angle = angle - 360.0f) : angle;
        return a1 + p * angle;
    }

    public static Side getEffectiveSide() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER || Thread.currentThread().getName().startsWith("Netty Epoll Server IO")) {
            return Side.SERVER;
        }
        return Side.CLIENT;
    }

    public static IBlockState getBlock(String par1) {
        String[] meta = par1.split(":");
        Block blocks = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(meta[0] + ":" + meta[1]));
        if (meta.length > 2) {
            return blocks.func_176203_a(Integer.parseInt(meta[2]));
        }
        return blocks.func_176223_P();
    }

    public static String localeBoolean(boolean bol) {
        return bol ? GCCoreUtil.translate((String)"gui.message.yes") : GCCoreUtil.translate((String)"gui.message.no");
    }

    static {
        texMap = null;
    }

    public static enum FluidType {
        STILL,
        FLOWING;

    }
}

