/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.utils.worldengine.perlinnoise;

import asmodeuscore.core.utils.worldengine.perlinnoise.WhiteNoise;

public abstract class GenNoiseTemplate {
    public long seed;
    public double persistence;
    public double scaleX;
    public double scaleY;
    public double scaleZ;
    public int octaves;
    public int height;
    public byte iType;
    public WhiteNoise rand;

    public GenNoiseTemplate(long gSeed, double gPersistence, int numOfOctaves, double scl_x, double scl_y, double scl_z, int sum, byte interpolation) {
        this.seed = gSeed;
        this.persistence = gPersistence;
        this.octaves = numOfOctaves;
        this.scaleX = scl_x;
        this.scaleY = scl_y;
        this.scaleZ = scl_z;
        this.height = sum;
        this.iType = interpolation;
        this.rand = new WhiteNoise(gSeed);
    }

    public GenNoiseTemplate(long gSeed, double gPersistence, int numOfOctaves, double scl_xz, double scl_y, int sum) {
        this(gSeed, gPersistence, numOfOctaves, scl_xz, scl_y, scl_xz, sum, 3);
    }

    public double lerp3d(double a, double b, double n) {
        return a + (b - a) * n;
    }

    public float lerp3f(float a, float b, float n) {
        return a + (b - a) * n;
    }

    public double smoothstep1d(double n) {
        return n * n * (3.0 - 2.0 * n);
    }

    public float smoothstep1f(float n) {
        return n * n * (3.0f - 2.0f * n);
    }

    public double smootherstep1d(double n) {
        return n * n * n * (n * (n * 6.0 - 15.0) + 10.0);
    }

    public float smootherstepcosine1f(float n) {
        return (float)((1.0 - Math.cos((double)n * Math.PI)) / 2.0);
    }

    public double smootherstepcosine1d(double n) {
        return (1.0 - Math.cos(n * Math.PI)) / 2.0;
    }

    public float smootherstep1f(float n) {
        return n * n * n * (n * (n * 6.0f - 15.0f) + 10.0f);
    }

    public double autoSmooth1d(double n) {
        switch (this.iType) {
            case 3: {
                return this.smootherstepcosine1d(n);
            }
            case 2: {
                return this.smootherstep1d(n);
            }
            case 1: {
                return this.smoothstep1d(n);
            }
        }
        return n;
    }

    public float autoSmooth1f(float n) {
        switch (this.iType) {
            case 3: {
                return this.smootherstepcosine1f(n);
            }
            case 2: {
                return this.smootherstep1f(n);
            }
            case 1: {
                return this.smoothstep1f(n);
            }
        }
        return n;
    }

    public double dot2d(double[] vec1, double[] vec2) {
        return vec1[0] * vec2[0] + vec1[1] * vec2[1];
    }

    public float dot2f(float[] vec1, float[] vec2) {
        return vec1[0] * vec2[0] + vec1[1] * vec2[1];
    }

    public abstract double noiseOctave2d(double var1, double var3);

    public abstract float noiseOctave2f(float var1, float var2);

    public double genNoise2d(double x, double z) {
        double result = 0.0;
        double amplitudeMultiplier = 1.0;
        double nowX = x;
        double nowZ = z;
        for (int i = 0; i < this.octaves; ++i) {
            result += this.noiseOctave2d(nowX / this.scaleX, nowZ / this.scaleZ) * amplitudeMultiplier;
            amplitudeMultiplier *= this.persistence;
            nowX *= 2.0;
            nowZ *= 2.0;
        }
        return (double)this.height + result * this.scaleY;
    }

    public float genNoise2f(float x, float z) {
        float result = 0.0f;
        float amplitudeMultiplier = 1.0f;
        float nowX = x;
        float nowZ = z;
        for (int i = 0; i < this.octaves; ++i) {
            result += this.noiseOctave2f(nowX / (float)this.scaleX, nowZ / (float)this.scaleZ) * amplitudeMultiplier;
            amplitudeMultiplier *= (float)this.persistence;
            nowX *= 2.0f;
            nowZ *= 2.0f;
        }
        return (float)this.height + result * (float)this.scaleY;
    }
}

