/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.MorePlanetsMod;
import stevekung.mods.moreplanets.init.MPSounds;
import stevekung.mods.moreplanets.network.PacketSimpleMP;
import stevekung.mods.moreplanets.tileentity.TileEntityDarkEnergyReceiver;
import stevekung.mods.moreplanets.utils.BlocksItemsRegistry;
import stevekung.mods.moreplanets.utils.EnumParticleTypesMP;
import stevekung.mods.moreplanets.utils.IDescription;
import stevekung.mods.moreplanets.utils.ItemDescription;
import stevekung.mods.moreplanets.utils.blocks.BlockTileMP;
import stevekung.mods.moreplanets.utils.blocks.EnumSortCategoryBlock;
import stevekung.mods.stevekunglib.utils.BlockStateProperty;
import stevekung.mods.stevekunglib.utils.ColorUtils;
import stevekung.mods.stevekunglib.utils.CommonUtils;
import stevekung.mods.stevekunglib.utils.JsonUtils;
import stevekung.mods.stevekunglib.utils.LangUtils;

public class BlockDarkEnergyReceiver
extends BlockTileMP
implements IDescription {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.225, 0.0, 0.225, 0.775, 0.7, 0.775);

    public BlockDarkEnergyReceiver(String name) {
        super(Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockStateProperty.FACING_HORIZON, (Comparable)EnumFacing.NORTH));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack heldStack) {
        TileEntity tile = world.func_175625_s(pos);
        world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)BlockStateProperty.FACING_HORIZON, (Comparable)placer.func_174811_aO().func_176734_d()));
        if (tile instanceof TileEntityDarkEnergyReceiver) {
            TileEntityDarkEnergyReceiver energy = (TileEntityDarkEnergyReceiver)world.func_175625_s(pos);
            energy.onCreate(world, pos);
            if (heldStack.func_77942_o() && heldStack.func_77978_p().func_74764_b("EnergyStored")) {
                energy.storage.setEnergyStored(heldStack.func_77978_p().func_74760_g("EnergyStored"));
            }
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack heldStack) {
        ItemStack machine = new ItemStack((Block)this);
        player.func_71020_j(0.025f);
        if (tile instanceof TileEntityDarkEnergyReceiver) {
            TileEntityDarkEnergyReceiver electric = (TileEntityDarkEnergyReceiver)tile;
            if (electric.getEnergyStoredGC() > 0.0f) {
                machine.func_77982_d(new NBTTagCompound());
                machine.func_77978_p().func_74776_a("EnergyStored", electric.getEnergyStoredGC());
            }
            if (!electric.successful && !electric.failed) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)machine);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!(world.func_175625_s(pos) instanceof TileEntityDarkEnergyReceiver)) return false;
        TileEntityDarkEnergyReceiver tile = (TileEntityDarkEnergyReceiver)world.func_175625_s(pos);
        if (player.func_70093_af()) {
            if (TileEntityDarkEnergyReceiver.checkValidMultiblock(pos, world)) {
                TileEntityDarkEnergyReceiver.multiBlockLists.forEach((blockpos, blockstate) -> {
                    BlockPos newPos = pos.func_177971_a((Vec3i)blockpos);
                    if (world.func_180495_p(newPos) != blockstate) {
                        Item item = Item.func_150898_a((Block)blockstate.func_177230_c());
                        String name = item.func_77653_i(new ItemStack(item));
                        player.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"gui.missing_block.message", (Object[])new Object[]{name, newPos.func_177958_n(), newPos.func_177956_o(), newPos.func_177952_p()})).func_150255_a(JsonUtils.red()));
                    }
                });
                return false;
            }
            if (tile.disabled) {
                player.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"gui.dark_energy_disabled.message")).func_150255_a(JsonUtils.red()));
                return false;
            }
            if (!(tile.getEnergyStoredGC() > 20000.0f)) {
                if (tile.isActivated()) return false;
                player.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"gui.dark_energy_no_power.message")).func_150255_a(JsonUtils.red()));
                return false;
            }
            if (!tile.isActivated()) {
                tile.setActivated(true);
                tile.func_145831_w().func_184133_a(player, tile.func_174877_v(), MPSounds.MACHINE_START, SoundCategory.BLOCKS, 1.0f, 1.0f);
                player.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"gui.dark_energy_success.message")).func_150255_a(JsonUtils.green()));
                return true;
            }
            player.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"gui.dark_energy_already_active.message")).func_150255_a(JsonUtils.red()));
            return false;
        }
        if (tile.failedTick > 0 && !tile.successful) {
            int failedTick = 600 - tile.failedTick;
            String s = "s";
            if (failedTick < 40) {
                s = "";
            }
            player.func_145747_a(JsonUtils.create((String)(LangUtils.translate((String)"gui.dark_energy_malfunction.message", (Object[])new Object[]{CommonUtils.ticksToElapsedTime((int)failedTick)}) + " second" + s + "!")).func_150255_a(JsonUtils.red()));
            return false;
        }
        if (tile.failed) return true;
        player.openGui((Object)"moreplanets", -1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDarkEnergyReceiver) {
            TileEntityDarkEnergyReceiver receiver = (TileEntityDarkEnergyReceiver)tile;
            receiver.onDestroy(tile);
            GalacticraftCore.packetPipeline.sendToDimension((IPacket)new PacketSimpleMP(PacketSimpleMP.EnumSimplePacketMP.C_REMOVE_GUIDE_POS, world.field_73011_w.getDimension(), receiver.func_174877_v()), world.field_73011_w.getDimension());
        }
        super.func_180663_b(world, pos, state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntity tile = world.func_175625_s(pos);
        boolean flag = true;
        if (tile instanceof TileEntityDarkEnergyReceiver) {
            TileEntityDarkEnergyReceiver dark = (TileEntityDarkEnergyReceiver)tile;
            if (dark.activated || dark.failed || dark.successful) {
                flag = false;
            }
        }
        if (flag) {
            ret.add(new ItemStack((Block)this, 1, 0));
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDarkEnergyReceiver) {
            TileEntityDarkEnergyReceiver dark = (TileEntityDarkEnergyReceiver)tile;
            if (dark.activated && !dark.successful) {
                int j;
                double d5;
                double d4;
                double d3;
                double d2;
                double d1;
                double d0;
                int i;
                for (i = 0; i < 32; ++i) {
                    d0 = (float)pos.func_177958_n() + rand.nextFloat();
                    d1 = (float)pos.func_177956_o() + rand.nextFloat();
                    d2 = (float)pos.func_177952_p() + rand.nextFloat();
                    d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
                    d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
                    d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
                    j = rand.nextInt(2) * 2 - 1;
                    d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                    d5 = rand.nextFloat() * 2.0f * (float)j;
                    MorePlanetsMod.PROXY.spawnParticle(EnumParticleTypesMP.DARK_PORTAL, d0, d1, d2, d3, d4, d5);
                }
                for (i = 0; i < 32; ++i) {
                    d0 = (float)pos.func_177958_n() + rand.nextFloat();
                    d1 = (float)pos.func_177956_o() + rand.nextFloat();
                    d2 = (float)pos.func_177952_p() + rand.nextFloat();
                    d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
                    d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
                    d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
                    j = rand.nextInt(2) * 2 - 1;
                    d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                    d3 = rand.nextFloat() * 2.0f * (float)j;
                    MorePlanetsMod.PROXY.spawnParticle(EnumParticleTypesMP.DARK_PORTAL, d0, d1, d2, d3, d4, d5);
                }
            }
        }
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDarkEnergyReceiver) {
            TileEntityDarkEnergyReceiver dark = (TileEntityDarkEnergyReceiver)tile;
            if ((dark.activated || dark.failed) && !dark.successful) {
                return false;
            }
        }
        return super.canHarvestBlock(world, pos, player);
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDarkEnergyReceiver) {
            TileEntityDarkEnergyReceiver dark = (TileEntityDarkEnergyReceiver)tile;
            if ((dark.activated || dark.failed) && !dark.successful) {
                return -1.0f;
            }
        }
        return super.func_180647_a(state, player, world, pos);
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDarkEnergyReceiver) {
            TileEntityDarkEnergyReceiver dark = (TileEntityDarkEnergyReceiver)tile;
            if ((dark.activated || dark.failed) && !dark.successful) {
                return -1.0f;
            }
        }
        return 2.0f;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityDarkEnergyReceiver();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory() {
        return EnumSortCategoryBlock.MACHINE_NON_BLOCK;
    }

    @Override
    public ItemDescription getDescription() {
        return (itemStack, list) -> list.addAll(BlocksItemsRegistry.getDescription(this.func_149739_a() + ".description"));
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)(meta % 4));
        return this.func_176223_P().func_177226_a((IProperty)BlockStateProperty.FACING_HORIZON, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockStateProperty.FACING_HORIZON)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockStateProperty.FACING_HORIZON});
    }

    @Override
    public ColorUtils.RGB getRarity() {
        return ColorUtils.stringToRGB((String)"0, 255, 207");
    }
}

