/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.client.gui.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelItemSlot;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.utils.QuestTranslation;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.TaskRetrieval;
import java.util.UUID;
import mezz.jei.Internal;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.gui.Focus;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Optional;

public class PanelTaskRetrieval
extends CanvasEmpty {
    private final TaskRetrieval task;

    public PanelTaskRetrieval(IGuiRect rect, TaskRetrieval task) {
        super(rect);
        this.task = task;
    }

    public void initPanel() {
        super.initPanel();
        UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        int[] progress = this.task.getUsersProgress(uuid);
        boolean isComplete = this.task.isComplete(uuid);
        String sCon = (this.task.consume ? TextFormatting.RED : TextFormatting.GREEN) + QuestTranslation.translate((String)(this.task.consume ? "gui.yes" : "gui.no"), (Object[])new Object[0]);
        this.addPanel((IGuiPanel)new PanelTextBox((IGuiRect)new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 0, 0, -16), 0), QuestTranslation.translate((String)"bq_standard.btn.consume", (Object[])new Object[]{sCon})).setColor(PresetColor.TEXT_MAIN.getColor()));
        CanvasScrolling cvList = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 16, 8, 0), 0));
        this.addPanel((IGuiPanel)cvList);
        PanelVScrollBar scList = new PanelVScrollBar((IGuiRect)new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 16, 0, 0), 0));
        this.addPanel((IGuiPanel)scList);
        cvList.setScrollDriverY((IValueIO)scList);
        int listW = cvList.getTransform().getWidth();
        for (int i = 0; i < this.task.requiredItems.size(); ++i) {
            BigItemStack stack = (BigItemStack)this.task.requiredItems.get(i);
            PanelItemSlot slot = new PanelItemSlot((IGuiRect)new GuiRectangle(0, i * 32, 32, 32, 0), -1, stack, false, true);
            if (BQ_Standard.hasJEI) {
                slot.setCallback(value -> this.lookupRecipe(value.getBaseStack()));
            }
            cvList.addPanel((IGuiPanel)slot);
            StringBuilder sb = new StringBuilder();
            sb.append(stack.getBaseStack().func_82833_r());
            if (stack.hasOreDict()) {
                sb.append(" (").append(stack.getOreDict()).append(")");
            }
            sb.append("\n").append(progress[i]).append("/").append(stack.stackSize).append("\n");
            if (isComplete || progress[i] >= stack.stackSize) {
                sb.append(TextFormatting.GREEN).append(QuestTranslation.translate((String)"betterquesting.tooltip.complete", (Object[])new Object[0]));
            } else {
                sb.append(TextFormatting.RED).append(QuestTranslation.translate((String)"betterquesting.tooltip.incomplete", (Object[])new Object[0]));
            }
            PanelTextBox text = new PanelTextBox((IGuiRect)new GuiRectangle(36, i * 32, listW - 36, 32, 0), sb.toString());
            text.setColor(PresetColor.TEXT_MAIN.getColor());
            cvList.addPanel((IGuiPanel)text);
        }
    }

    @Optional.Method(modid="jei")
    private void lookupRecipe(ItemStack stack) {
        if (stack == null || stack.func_190926_b() || Internal.getRuntime() == null) {
            return;
        }
        Internal.getRuntime().getRecipesGui().show((IFocus)new Focus(IFocus.Mode.OUTPUT, (Object)stack));
    }
}

