/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Index<K, V> {
    private final Map<K, V> keyToValue;
    private final Map<V, K> valueToKey;

    private Index(Map<K, V> keyToValue, Map<V, K> valueToKey) {
        this.keyToValue = keyToValue;
        this.valueToKey = valueToKey;
    }

    public static <K, V extends Enum<V>> @NonNull Index<K, V> create(Class<V> type, @NonNull Function<? super V, ? extends K> keyFunction) {
        return Index.create(type, keyFunction, (Enum[])((Enum[])type.getEnumConstants()));
    }

    @SafeVarargs
    public static <K, V extends Enum<V>> @NonNull Index<K, V> create(Class<V> type, @NonNull Function<? super V, ? extends K> keyFunction, V ... values) {
        return Index.create(values, (int length) -> new EnumMap(type), keyFunction);
    }

    @SafeVarargs
    public static <K, V> @NonNull Index<K, V> create(@NonNull Function<? super V, ? extends K> keyFunction, V ... values) {
        return Index.create(values, HashMap::new, keyFunction);
    }

    public static <K, V> @NonNull Index<K, V> create(@NonNull Function<? super V, ? extends K> keyFunction, @NonNull List<V> constants) {
        return Index.create(constants, HashMap::new, keyFunction);
    }

    private static <K, V> @NonNull Index<K, V> create(V[] values, IntFunction<Map<V, K>> valueToKeyFactory, @NonNull Function<? super V, ? extends K> keyFunction) {
        return Index.create(Arrays.asList(values), valueToKeyFactory, keyFunction);
    }

    private static <K, V> @NonNull Index<K, V> create(List<V> values, IntFunction<Map<V, K>> valueToKeyFactory, @NonNull Function<? super V, ? extends K> keyFunction) {
        int length = values.size();
        HashMap<K, V> keyToValue = new HashMap<K, V>(length);
        Map<K, V> valueToKey = valueToKeyFactory.apply(length);
        for (int i = 0; i < length; ++i) {
            V value = values.get(i);
            K key = keyFunction.apply(value);
            if (keyToValue.putIfAbsent(key, value) != null) {
                throw new IllegalStateException(String.format("Key %s already mapped to value %s", key, keyToValue.get(key)));
            }
            if (valueToKey.putIfAbsent(value, key) == null) continue;
            throw new IllegalStateException(String.format("Value %s already mapped to key %s", value, valueToKey.get(value)));
        }
        return new Index(Collections.unmodifiableMap(keyToValue), Collections.unmodifiableMap(valueToKey));
    }

    public @NonNull Set<K> keys() {
        return Collections.unmodifiableSet(this.keyToValue.keySet());
    }

    public @Nullable K key(@NonNull V value) {
        return this.valueToKey.get(value);
    }

    public @NonNull Set<V> values() {
        return Collections.unmodifiableSet(this.valueToKey.keySet());
    }

    public @Nullable V value(@NonNull K key) {
        return this.keyToValue.get(key);
    }
}

