/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.ae2wtlib.integration;

import baubles.api.IBauble;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import baubles.common.container.SlotBauble;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.tuple.Pair;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.ae2wtlib.api.WTBaublesAccess;
import p455w0rd.ae2wtlib.api.container.ContainerWT;
import p455w0rd.ae2wtlib.api.container.slot.SlotAEBauble;
import p455w0rd.ae2wtlib.init.LibNetworking;
import p455w0rd.ae2wtlib.sync.packets.PacketBaubleSync;

public class Baubles
extends WTBaublesAccess {
    @Override
    public Pair<Integer, ItemStack> getFirstWTBauble(EntityPlayer player) {
        if (!this.getAllWTBaubles(player).isEmpty()) {
            return (Pair)this.getAllWTBaubles(player).stream().findFirst().get();
        }
        return Pair.of((Object)-1, (Object)ItemStack.field_190927_a);
    }

    @Override
    public Set<Pair<Integer, ItemStack>> getAllWTBaubles(EntityPlayer player) {
        HashSet list = Sets.newHashSet();
        if (player.hasCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null)) {
            IBaublesItemHandler baubles = (IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null);
            for (int i = 0; i < baubles.getSlots(); ++i) {
                if (baubles.getStackInSlot(i).func_190926_b() || !(baubles.getStackInSlot(i).func_77973_b() instanceof ICustomWirelessTerminalItem)) continue;
                list.add(Pair.of((Object)i, (Object)baubles.getStackInSlot(i)));
            }
        }
        return list;
    }

    @Override
    public Set<Pair<Integer, ItemStack>> getAllWTBaublesByType(EntityPlayer player, Class<? extends ICustomWirelessTerminalItem> type) {
        HashSet list = Sets.newHashSet();
        if (player.hasCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null)) {
            IBaublesItemHandler baubles = (IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null);
            for (int i = 0; i < baubles.getSlots(); ++i) {
                HashSet applicableInterfaces;
                if (baubles.getStackInSlot(i).func_190926_b() || !(applicableInterfaces = Sets.newHashSet((Iterable)ClassUtils.getAllInterfaces(baubles.getStackInSlot(i).func_77973_b().getClass()))).contains(type) && !WTApi.instance().getWUTUtility().doesWUTSupportType(baubles.getStackInSlot(i), type)) continue;
                list.add(Pair.of((Object)i, (Object)baubles.getStackInSlot(i)));
            }
        }
        return list;
    }

    @Override
    public Pair<Integer, ItemStack> getFirstWTBaubleByType(EntityPlayer player, Class<? extends ICustomWirelessTerminalItem> type) {
        ArrayList baubleList = Lists.newArrayList(this.getAllWTBaublesByType(player, type));
        if (baubleList.size() > 0) {
            return (Pair)baubleList.get(0);
        }
        return Pair.of((Object)-1, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void updateWTBauble(EntityPlayer player, ItemStack wirelessTerm, int slot) {
        IBaublesItemHandler baubles;
        if (player.hasCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null) && !(baubles = (IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null)).getStackInSlot(slot).func_190926_b() && baubles.getStackInSlot(slot).func_77973_b() instanceof ICustomWirelessTerminalItem) {
            baubles.setStackInSlot(slot, wirelessTerm);
            baubles.setChanged(slot, true);
        }
    }

    @Override
    public ItemStack getWTBySlot(EntityPlayer player, int slot, Class<? extends ICustomWirelessTerminalItem> type) {
        IBaublesItemHandler baubles;
        ItemStack wirelessTerminal;
        if (player.hasCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null) && !(wirelessTerminal = (baubles = (IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null)).getStackInSlot(slot)).func_190926_b()) {
            List applicableInterfaces = ClassUtils.getAllInterfaces(wirelessTerminal.func_77973_b().getClass());
            if (!wirelessTerminal.func_190926_b() && (applicableInterfaces.contains(type) || WTApi.instance().getWUTUtility().doesWUTSupportType(wirelessTerminal, type))) {
                return wirelessTerminal;
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public IBaublesItemHandler getBaubles(EntityPlayer player) {
        if (player.hasCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null)) {
            return (IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null);
        }
        return null;
    }

    @Override
    public void setBaublesItemStack(EntityPlayer player, int slot, ItemStack stack) {
        if (player.hasCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null)) {
            IBaublesItemHandler baubles = (IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null);
            baubles.setStackInSlot(slot, stack);
        }
    }

    @Override
    public void addBaubleSlots(ContainerWT container, EntityPlayer player) {
        IBaublesItemHandler baubles = (IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null);
        for (int i = 0; i < 7; ++i) {
            container.func_75146_a((Slot)new SlotAEBauble((IItemHandler)baubles, i, 178, -62 + i * 18));
        }
    }

    @Override
    public boolean isBaubleItem(ItemStack stack) {
        return stack.func_77973_b() instanceof IBauble;
    }

    @Override
    public boolean isAEBaubleSlot(Slot slot) {
        return slot instanceof SlotAEBauble;
    }

    @Override
    public boolean isBaubleSlot(Slot slot) {
        return slot instanceof SlotBauble;
    }

    @Override
    public void sync(EntityPlayer player, ItemStack stack, int slot) {
        if (player instanceof EntityPlayerMP) {
            IBaublesItemHandler inv = this.getBaubles(player);
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack currentStack = inv.getStackInSlot(i);
                if (!(currentStack.func_77973_b() instanceof IBauble)) continue;
                this.updateWTBauble(player, stack, slot);
                LibNetworking.instance().sendTo(new PacketBaubleSync(stack, slot), (EntityPlayerMP)player);
            }
        }
    }
}

