/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import vswe.superfactory.blocks.IRedstoneNode;
import vswe.superfactory.blocks.ITriggerNode;
import vswe.superfactory.components.internal.SideSlotTarget;
import vswe.superfactory.tiles.TileEntityBUD;
import vswe.superfactory.tiles.TileEntityCamouflage;
import vswe.superfactory.tiles.TileEntityInput;
import vswe.superfactory.tiles.TileEntityOutput;
import vswe.superfactory.tiles.TileEntitySignUpdater;
import vswe.superfactory.util.CapabilityUtils;

public class SlotInventoryHolder {
    private int id;
    private TileEntity inventory;
    private int sharedOption;
    private Map<EnumFacing, SideSlotTarget> validSlots;

    public SlotInventoryHolder(int id, TileEntity inventory, int sharedOption) {
        this.id = id;
        this.inventory = inventory;
        this.sharedOption = sharedOption;
    }

    public int getId() {
        return this.id;
    }

    @Nullable
    public IItemHandler getInventory(EnumFacing facing) {
        return CapabilityUtils.getItemHandler(this.inventory, facing);
    }

    @Nullable
    public IFluidHandler getTank(EnumFacing facing) {
        return CapabilityUtils.getFluidHandler(this.inventory, facing);
    }

    public TileEntityOutput getEmitter() {
        return (TileEntityOutput)this.inventory;
    }

    public IRedstoneNode getNode() {
        return (IRedstoneNode)this.inventory;
    }

    public TileEntityInput getReceiver() {
        return (TileEntityInput)this.inventory;
    }

    public TileEntityBUD getBUD() {
        return (TileEntityBUD)this.inventory;
    }

    public TileEntityCamouflage getCamouflage() {
        return (TileEntityCamouflage)this.inventory;
    }

    public TileEntitySignUpdater getSign() {
        return (TileEntitySignUpdater)this.inventory;
    }

    public Map<EnumFacing, SideSlotTarget> getValidSlots() {
        if (this.validSlots == null) {
            this.validSlots = new LinkedHashMap<EnumFacing, SideSlotTarget>();
        }
        return this.validSlots;
    }

    public boolean isShared() {
        return this.sharedOption == 0;
    }

    public int getSharedOption() {
        return this.sharedOption;
    }

    public int hashCode() {
        return this.inventory.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotInventoryHolder that = (SlotInventoryHolder)o;
        return this.inventory.func_174877_v().func_177958_n() == that.inventory.func_174877_v().func_177958_n() && this.inventory.func_174877_v().func_177956_o() == that.inventory.func_174877_v().func_177956_o() && this.inventory.func_174877_v().func_177952_p() == that.inventory.func_174877_v().func_177956_o();
    }

    public TileEntity getTile() {
        return this.inventory;
    }

    public ITriggerNode getTrigger() {
        return (ITriggerNode)this.inventory;
    }
}

