/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.commands.nucleus;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.modules.core.commands.NucleusCommand;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.interfaces.ICompatibilityService;
import java.util.Collection;
import java.util.Comparator;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;

@Command(aliases={"compatibility", "compat"}, basePermission={"nucleus.nucleus.compatibility.base"}, commandDescriptionKey="nucleus.compatibility", parentCommand=NucleusCommand.class, async=true)
public class CompatibilityCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) {
        ICompatibilityService compatibilityService = context.getServiceCollection().compatibilityService();
        Collection<ICompatibilityService.CompatibilityMessages> messages = compatibilityService.getApplicableMessages();
        if (messages.isEmpty()) {
            context.sendMessage("command.nucleus.compat.none", new Object[0]);
            return context.successResult();
        }
        Text text = messages.stream().sorted(Comparator.comparing(x -> -x.getSeverity().getIndex())).map(x -> {
            Text modulesAffected = x.getModules().isEmpty() ? context.getMessage("command.nucleus.compat.all", new Object[0]) : Text.of((String)String.join((CharSequence)" ,", x.getModules()));
            return Text.joinWith((Text)Text.NEW_LINE, (Text[])new Text[]{context.getMessage("command.nucleus.compat.severity.base", "loc:command.nucleus.compat.severity." + x.getSeverity().name().toLowerCase()), context.getMessage("command.nucleus.compat.modulesaffected", modulesAffected), context.getMessage("command.nucleus.compat.mod", x.getModId()), context.getMessage("command.nucleus.compat.symptom", new Object[]{x.getSeverity()}), context.getMessage("command.nucleus.compat.message", x.getMessage()), context.getMessage("command.nucleus.compat.resolution", x.getResolution())});
        }).reduce((text1, text2) -> Text.of((Object[])new Object[]{text1, Text.NEW_LINE, Text.NEW_LINE, text2})).orElse(Text.EMPTY);
        Util.getPaginationBuilder(context.getCommandSourceUnchecked()).header(context.getMessage("command.nucleus.compat.header", new Object[0])).contents(new Text[]{text}).sendTo((MessageReceiver)context.getCommandSourceUnchecked());
        return context.successResult();
    }
}

