/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.fun.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.translation.Translatable;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@EssentialsEquivalent(value={"hat", "head"})
@NonnullByDefault
@Command(aliases={"hat", "head"}, basePermission={"nucleus.hat.base"}, commandDescriptionKey="hat", associatedPermissions={"nucleus.hat.others"})
public class HatCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.commandElementSupplier().createOnlyOtherUserPermissionElement(true, "nucleus.hat.others")};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Player pl = context.getPlayerFromArgs();
        boolean isSelf = context.is(pl);
        Optional helmetOptional = pl.getHelmet();
        ItemStack stack = (ItemStack)pl.getItemInHand(HandTypes.MAIN_HAND).orElseThrow(() -> context.createException("command.generalerror.handempty", new Object[0]));
        ItemStack hand = stack.copy();
        hand.setQuantity(1);
        pl.setHelmet(hand);
        Text itemName = hand.get(Keys.DISPLAY_NAME).orElseGet(() -> Text.of((Translatable)stack, (Object[])new Object[0]));
        GameMode gameMode = pl.get(Keys.GAME_MODE).orElse(GameModes.NOT_SET);
        if (gameMode != GameModes.CREATIVE) {
            if (stack.getQuantity() > 1) {
                stack.setQuantity(stack.getQuantity() - 1);
                pl.setItemInHand(HandTypes.MAIN_HAND, stack);
            } else {
                pl.setItemInHand(HandTypes.MAIN_HAND, null);
            }
        }
        helmetOptional.ifPresent(itemStack -> Util.getStandardInventory((Carrier)pl).offer(itemStack.copy()).getRejectedItems().forEach(x -> Util.dropItemOnFloorAtLocation(x, pl.getWorld(), pl.getLocation().getPosition())));
        if (!isSelf) {
            context.sendMessage("command.hat.success", context.getServiceCollection().playerDisplayNameService().getDisplayName(pl.getUniqueId()), itemName);
        }
        context.sendMessageTo((MessageReceiver)pl, "command.hat.successself", itemName);
        return context.successResult();
    }
}

