/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.item.commands.itemname;

import io.github.nucleuspowered.nucleus.modules.item.commands.itemname.ItemNameCommand;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"set", "#setitemname", "#renameitem"}, basePermission={"nucleus.itemname.set.base"}, commandDescriptionKey="itemname.set", parentCommand=ItemNameCommand.class, modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.itemname.set.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.itemname.set.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.itemname.set.exempt.cost")})
public class ItemNameSetCommand
implements ICommandExecutor<Player> {
    private final String nameKey = "name";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.remainingJoinedStrings((Text)Text.of((String)this.nameKey))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Text name;
        Player src = context.getIfPlayer();
        if (!src.getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
            return context.errorResult("command.itemname.set.noitem", new Object[0]);
        }
        ItemStack stack = (ItemStack)src.getItemInHand(HandTypes.MAIN_HAND).get();
        if (stack.offer(Keys.DISPLAY_NAME, (Object)(name = TextSerializers.FORMATTING_CODE.deserialize(context.requireOne(this.nameKey, String.class)))).isSuccessful()) {
            src.setItemInHand(HandTypes.MAIN_HAND, stack);
            context.sendMessage("command.itemname.set.success", new Object[0]);
            return context.successResult();
        }
        return context.errorResult("command.itemname.set.fail", new Object[0]);
    }
}

