/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.misc.commands;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.util.DataScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.util.blockray.BlockRayHit;

@NonnullByDefault
@Command(aliases={"entityinfo"}, basePermission={"nucleus.entityinfo.base"}, commandDescriptionKey="entityinfo", associatedPermissions={"nucleus.entityinfo.extended"})
public class EntityInfoCommand
implements ICommandExecutor<Player> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().permissionFlag("nucleus.entityinfo.extended", new String[]{"e", "-extended"}).buildWith(GenericArguments.none())};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Player player = context.getIfPlayer();
        Vector3i playerPos = player.getLocation().getBlockPosition();
        Collection entities = player.getWorld().getEntities().stream().filter(x -> x.getLocation().getBlockPosition().distanceSquared(playerPos) < 121).collect(Collectors.toList());
        BlockRay bl = BlockRay.from((Entity)player).distanceLimit(10.0).stopFilter(BlockRay.continueAfterFilter(x -> {
            Vector3i pt1 = x.getLocation().getBlockPosition();
            Vector3i pt2 = pt1.add(0, 1, 0);
            return entities.stream().allMatch(e -> {
                Vector3i current = e.getLocation().getBlockPosition();
                return !current.equals((Object)pt1) && !current.equals((Object)pt2);
            });
        }, (int)1)).build();
        Optional ob = bl.end();
        if (ob.isPresent()) {
            BlockRayHit brh = (BlockRayHit)ob.get();
            Vector3d location = brh.getLocation().getPosition();
            Vector3d locationOneUp = location.add(0.0f, 1.0f, 0.0f);
            Optional<Entity> entityOptional = entities.stream().filter(e -> {
                Vector3i current = e.getLocation().getBlockPosition();
                return current.equals((Object)location.toInt()) || current.equals((Object)locationOneUp.toInt());
            }).min(Comparator.comparingDouble(x -> x.getLocation().getPosition().distanceSquared(location)));
            if (entityOptional.isPresent()) {
                Entity entity = entityOptional.get();
                EntityType type = entity.getType();
                ArrayList<Text> lt = new ArrayList<Text>();
                lt.add(context.getMessage("command.entityinfo.id", type.getId(), Util.getTranslatableIfPresent(type)));
                lt.add(context.getMessage("command.entityinfo.uuid", entity.getUniqueId().toString()));
                if (context.hasAny("e") || context.hasAny("extended")) {
                    DataScanner.getInstance(context.getServiceCollection().messageProvider()).getKeysForHolder((DataHolder)entity).entrySet().stream().filter(x -> x.getValue() != null).filter(x -> {
                        try {
                            return entity.supports((Key)x.getValue());
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }).forEach(x -> {
                        Key k = (Key)x.getValue();
                        if (entity.get(k).isPresent()) {
                            DataScanner.getInstance(context.getServiceCollection().messageProvider()).getText((CommandSource)player, "command.entityinfo.key", (String)x.getKey(), entity.get(k).get()).ifPresent(lt::add);
                        }
                    });
                }
                ((PaginationService)Sponge.getServiceManager().provideUnchecked(PaginationService.class)).builder().contents(lt).padding(Text.of((Object[])new Object[]{TextColors.GREEN, "-"})).title(context.getMessage("command.entityinfo.list.header", String.valueOf(brh.getBlockX()), String.valueOf(brh.getBlockY()), String.valueOf(brh.getBlockZ()))).sendTo((MessageReceiver)player);
                return context.successResult();
            }
        }
        return context.errorResult("command.entityinfo.none", new Object[0]);
    }
}

