/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.misc.commands;

import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"extinguish", "ext"}, basePermission={"nucleus.extinguish.base"}, commandDescriptionKey="extinguish", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.extinguish.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.extinguish.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.extinguish.exempt.cost")}, associatedPermissions={"nucleus.extinguish.others"})
public class ExtinguishCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.commandElementSupplier().createOnlyOtherUserPermissionElement(true, "nucleus.extinguish.others")};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Player target = context.getPlayerFromArgs();
        if (target.get(Keys.FIRE_TICKS).orElse(-1) > 0 && target.offer(Keys.FIRE_TICKS, (Object)0).isSuccessful()) {
            context.sendMessage("command.extinguish.success", target.getName());
            return context.successResult();
        }
        return context.errorResult("command.extinguish.failed", target.getName());
    }
}

