/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.playerinfo.commands;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.text.NucleusTextTemplate;
import io.github.nucleuspowered.nucleus.modules.afk.services.AFKHandler;
import io.github.nucleuspowered.nucleus.modules.playerinfo.config.ListConfig;
import io.github.nucleuspowered.nucleus.modules.playerinfo.config.PlayerInfoConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPlayerOnlineService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@EssentialsEquivalent(value={"list", "who", "playerlist", "online", "plist"})
@Command(async=true, aliases={"list", "listplayers", "ls"}, basePermission={"nucleus.list.base"}, commandDescriptionKey="list", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.list.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.list.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.list.exempt.cost")}, associatedPermissions={"nucleus.list.seevanished"})
public class ListPlayerCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    public static final String LIST_OPTION = "nucleus.list.group";
    private ListConfig listConfig = new ListConfig();

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        boolean showVanished = context.testPermission("nucleus.list.seevanished");
        Collection players = Sponge.getServer().getOnlinePlayers();
        long playerCount = players.size();
        long hiddenCount = players.stream().filter(x -> x.get(Keys.VANISH).orElse(false)).count();
        Text header = showVanished && hiddenCount > 0L ? context.getMessage("command.list.playercount.hidden", String.valueOf(playerCount), String.valueOf(Sponge.getServer().getMaxPlayers()), String.valueOf(hiddenCount)) : context.getMessage("command.list.playercount.base", String.valueOf(playerCount - hiddenCount), String.valueOf(Sponge.getServer().getMaxPlayers()));
        PaginationList.Builder builder = Util.getPaginationBuilder(context.getCommandSource()).title(header);
        Optional optPermissionService = Sponge.getServiceManager().provide(PermissionService.class);
        if (this.listConfig.isGroupByPermissionGroup() && optPermissionService.isPresent()) {
            builder.contents(this.listByPermissionGroup(context, showVanished));
        } else {
            builder.contents(this.getPlayerList(players, showVanished, context));
        }
        builder.sendTo((MessageReceiver)context.getCommandSource());
        return context.successResult();
    }

    private List<Text> listByPermissionGroup(ICommandContext<? extends CommandSource> context, boolean showVanished) {
        ArrayList messages = Lists.newArrayList();
        String defName = this.listConfig.getDefaultGroupName();
        Map<String, List<Player>> groupToPlayer = this.playerList(context, showVanished, defName);
        this.listConfig.getOrder().forEach(alias -> {
            List plList = (List)groupToPlayer.get(alias);
            if (plList != null && !plList.isEmpty()) {
                this.getList(plList, showVanished, messages, (String)alias, context);
            }
            groupToPlayer.remove(alias);
        });
        groupToPlayer.entrySet().stream().filter(x -> !((List)x.getValue()).isEmpty()).filter(x -> !((String)x.getKey()).equals(defName)).sorted((x, y) -> ((String)x.getKey()).compareToIgnoreCase((String)y.getKey())).forEach(x -> this.getList((Collection)x.getValue(), showVanished, messages, (String)x.getKey(), context));
        List<Player> pl = groupToPlayer.get(defName);
        if (pl != null && !pl.isEmpty()) {
            this.getList(pl, showVanished, messages, defName, context);
        }
        return messages;
    }

    private Map<String, List<Player>> playerList(ICommandContext<? extends CommandSource> context, boolean showVanished, String def) {
        IPlayerOnlineService playerOnlineService = context.getServiceCollection().playerOnlineService();
        IPermissionService permissionService = context.getServiceCollection().permissionService();
        HashMap<String, List<Player>> map = new HashMap<String, List<Player>>();
        for (Player player : Sponge.getServer().getOnlinePlayers()) {
            if (!showVanished && !playerOnlineService.isOnline(context.getCommandSourceUnchecked(), (User)player)) continue;
            String perm = permissionService.getOptionFromSubject((Subject)player, LIST_OPTION).orElse(def);
            if (perm.trim().isEmpty()) {
                perm = def;
            }
            map.computeIfAbsent(perm, y -> new ArrayList()).add(player);
        }
        return map;
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.listConfig = serviceCollection.moduleDataProvider().getModuleConfig(PlayerInfoConfig.class).getList();
    }

    private void getList(Collection<Player> player, boolean showVanished, List<Text> messages, String groupName, ICommandContext<? extends CommandSource> context) {
        Text groupNameText = TextSerializers.FORMATTING_CODE.deserialize(groupName);
        List<Text> m = this.getPlayerList(player, showVanished, context);
        if (this.listConfig.isCompact()) {
            boolean isFirst = true;
            for (Text y : m) {
                Text.Builder tb = Text.builder();
                if (isFirst) {
                    tb.append(new Text[]{Text.of((Object[])new Object[]{TextColors.YELLOW, groupNameText, ": "})});
                }
                isFirst = false;
                messages.add(tb.append(new Text[]{y}).build());
            }
        } else {
            messages.add(Text.of((Object[])new Object[]{TextColors.YELLOW, groupNameText, ":"}));
            messages.addAll(m);
        }
    }

    private List<Text> getPlayerList(Collection<Player> playersToList, boolean showVanished, ICommandContext<? extends CommandSource> context) {
        NucleusTextTemplate template = this.listConfig.getListTemplate();
        AFKHandler handler = context.getServiceCollection().getService(AFKHandler.class).orElse(null);
        Text afk = context.getMessage("command.list.afk", new Object[0]);
        Text hidden = context.getMessage("command.list.hidden", new Object[0]);
        List<Text> playerList = playersToList.stream().filter(x -> showVanished || x.get(Keys.VANISH).orElse(false) == false).sorted((x, y) -> x.getName().compareToIgnoreCase(y.getName())).map(x -> {
            Text.Builder tb = Text.builder();
            boolean appendSpace = false;
            if (handler != null && handler.isAFK((Player)x)) {
                tb.append(new Text[]{afk});
                appendSpace = true;
            }
            if (x.get(Keys.VANISH).orElse(false).booleanValue()) {
                tb.append(new Text[]{hidden});
                appendSpace = true;
            }
            if (appendSpace) {
                tb.append(new Text[]{Text.of((String)" ")});
            }
            if (template != null) {
                return tb.append(new Text[]{template.getForCommandSource((CommandSource)x)}).build();
            }
            return tb.append(new Text[]{context.getDisplayName(x.getUniqueId())}).build();
        }).collect(Collectors.toList());
        if (this.listConfig.isCompact() && !playerList.isEmpty()) {
            ArrayList<Text> toReturn = new ArrayList<Text>();
            List parts = Lists.partition(playerList, (int)this.listConfig.getMaxPlayersPerLine());
            for (List p : parts) {
                Text.Builder tb = Text.builder();
                boolean isFirst = true;
                for (Text text : p) {
                    if (!isFirst) {
                        tb.append(new Text[]{Text.of((Object[])new Object[]{TextColors.WHITE, ", "})});
                    }
                    tb.append(new Text[]{text});
                    isFirst = false;
                }
                toReturn.add(tb.build());
            }
            return toReturn;
        }
        return playerList;
    }
}

