/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.staffchat.commands;

import io.github.nucleuspowered.nucleus.api.EventContexts;
import io.github.nucleuspowered.nucleus.api.util.NoExceptionAutoClosable;
import io.github.nucleuspowered.nucleus.modules.staffchat.StaffChatMessageChannel;
import io.github.nucleuspowered.nucleus.modules.staffchat.services.StaffChatService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.userprefs.NucleusKeysProvider;
import io.github.nucleuspowered.nucleus.services.interfaces.IChatMessageFormatterService;
import java.util.Optional;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"staffchat", "sc", "a"}, basePermission={"nucleus.staffchat.base"}, commandDescriptionKey="staffchat")
public class StaffChatCommand
implements ICommandExecutor<CommandSource> {
    private final IChatMessageFormatterService chatMessageFormatterService;

    @Inject
    public StaffChatCommand(INucleusServiceCollection serviceCollection) {
        this.chatMessageFormatterService = serviceCollection.chatMessageFormatter();
    }

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.OPTIONAL_MESSAGE};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        StaffChatService service;
        Optional<String> toSend = context.getOne("message", String.class);
        if (toSend.isPresent()) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                Object c;
                frame.addContext(EventContexts.SHOULD_FORMAT_CHANNEL, (Object)StaffChatMessageChannel.getInstance().formatMessages());
                if (context.is(Player.class)) {
                    Player pl = context.getIfPlayer();
                    frame.pushCause((Object)pl);
                    frame.addContext(EventContextKeys.PLAYER_SIMULATED, (Object)pl.getProfile());
                    try (NoExceptionAutoClosable c2 = this.chatMessageFormatterService.setPlayerNucleusChannelTemporarily(pl.getUniqueId(), StaffChatMessageChannel.getInstance());){
                        pl.simulateChat(context.getServiceCollection().textStyleService().addUrls(toSend.get()), Sponge.getCauseStackManager().getCurrentCause());
                    }
                    context.getServiceCollection().userPreferenceService().setPreferenceFor((User)pl, NucleusKeysProvider.VIEW_STAFF_CHAT, true);
                } else {
                    frame.pushCause((Object)context.getCommandSourceUnchecked());
                    c = this.chatMessageFormatterService.setCommandSourceNucleusChannelTemporarily(context.getCommandSource(), StaffChatMessageChannel.getInstance());
                    Throwable throwable = null;
                    try {
                        StaffChatMessageChannel.getInstance().sendMessageFrom(context.getCommandSource(), context.getServiceCollection().textStyleService().addUrls(toSend.get()));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (c != null) {
                            if (throwable != null) {
                                try {
                                    c.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                c.close();
                            }
                        }
                    }
                }
                c = context.successResult();
                return c;
            }
        }
        if (!context.is(Player.class)) {
            return context.errorResult("command.staffchat.consoletoggle", new Object[0]);
        }
        Player player = context.getIfPlayer();
        boolean result = (service = context.getServiceCollection().getServiceUnchecked(StaffChatService.class)).isToggledChat(player);
        service.toggle(player, !result);
        context.sendMessage("command.staffchat." + (!result ? "on" : "off"), new Object[0]);
        return context.successResult();
    }
}

