/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.messageprovider.repository;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.typesafe.config.ConfigException;
import io.github.nucleuspowered.nucleus.services.impl.messageprovider.repository.AbstractMessageRepository;
import io.github.nucleuspowered.nucleus.services.impl.messageprovider.repository.IMessageRepository;
import io.github.nucleuspowered.nucleus.services.impl.messageprovider.repository.PropertiesMessageRepository;
import io.github.nucleuspowered.nucleus.services.interfaces.IPlayerDisplayNameService;
import io.github.nucleuspowered.nucleus.services.interfaces.ITextStyleService;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import org.slf4j.Logger;

public class ConfigFileMessagesRepository
extends AbstractMessageRepository
implements IMessageRepository {
    private static final Pattern KEYS = Pattern.compile("\\{(\\d+)}");
    private boolean isFailed = false;
    private final Path file;
    private final Logger logger;
    private final Supplier<PropertiesMessageRepository> messageRepositorySupplier;
    private final Map<String, String> entryCache = new HashMap<String, String>();
    private CommentedConfigurationNode node = CommentedConfigurationNode.root();

    public ConfigFileMessagesRepository(ITextStyleService textStyleService, IPlayerDisplayNameService playerDisplayNameService, Logger logger, Path file, Supplier<PropertiesMessageRepository> messageRepositorySupplier) {
        super(textStyleService, playerDisplayNameService);
        this.file = file;
        this.messageRepositorySupplier = messageRepositorySupplier;
        this.logger = logger;
    }

    public boolean isFailed() {
        return this.isFailed;
    }

    @Override
    public void invalidateIfNecessary() {
        this.invalidateIfNecessary(false);
    }

    public void invalidateIfNecessary(boolean firstLoad) {
        this.cachedMessages.clear();
        this.cachedStringMessages.clear();
        this.load(firstLoad);
    }

    @Override
    public boolean hasEntry(String key) {
        return this.entryCache.containsKey(key) || !this.node.getNode((Object[])key.split("\\.")).isVirtual();
    }

    @Override
    String getEntry(String key) {
        if (!this.entryCache.containsKey(key)) {
            String val = this.node.getNode((Object[])key.split("\\.")).getString();
            if (val == null) {
                val = this.messageRepositorySupplier.get().getEntry(key);
            }
            this.entryCache.put(key, val);
        }
        return this.entryCache.get(key);
    }

    protected CommentedConfigurationNode getDefaults() {
        CommentedConfigurationNode ccn = CommentedConfigurationNode.root();
        PropertiesMessageRepository repository = this.messageRepositorySupplier.get();
        repository.getKeys().forEach(x -> ccn.getNode((Object[])x.split("\\.")).setValue((Object)repository.getEntry((String)x)));
        return ccn;
    }

    protected HoconConfigurationLoader getLoader(Path file) {
        return ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(file)).build();
    }

    public Optional<String> getKey(@Nonnull String key) {
        Preconditions.checkNotNull((Object)key);
        Object[] obj = key.split("\\.");
        return Optional.ofNullable(this.node.getNode(obj).getString());
    }

    public List<String> walkThroughForMismatched() {
        Matcher keyMatcher = KEYS.matcher("");
        ArrayList keysToFix = Lists.newArrayList();
        PropertiesMessageRepository propertiesMessageRepository = this.messageRepositorySupplier.get();
        propertiesMessageRepository.getKeys().forEach(x -> {
            String resKey = propertiesMessageRepository.getEntry((String)x);
            Optional<String> msgKey = this.getKey((String)x);
            if (msgKey.isPresent() && this.getTokens(resKey, keyMatcher) != this.getTokens(msgKey.get(), keyMatcher)) {
                keysToFix.add(x);
            }
        });
        return keysToFix;
    }

    public void fixMismatched(List<String> toFix) {
        Preconditions.checkNotNull(toFix);
        PropertiesMessageRepository propertiesMessageRepository = this.messageRepositorySupplier.get();
        toFix.forEach(x -> {
            String resKey = propertiesMessageRepository.getEntry((String)x);
            Optional<String> msgKey = this.getKey((String)x);
            Object[] nodeKey = x.split("\\.");
            CommentedConfigurationNode cn = this.node.getNode(nodeKey).setValue((Object)resKey);
            msgKey.ifPresent(arg_0 -> ((CommentedConfigurationNode)cn).setComment(arg_0));
        });
        this.save();
    }

    private int getTokens(String message, Matcher matcher) {
        int result = -1;
        matcher.reset(message);
        while (matcher.find()) {
            result = Math.max(result, Integer.parseInt(matcher.group(1)));
        }
        return result;
    }

    private void load(boolean firstLoad) {
        try {
            this.node = (CommentedConfigurationNode)this.getLoader(this.file).load();
            this.entryCache.clear();
            this.isFailed = false;
        }
        catch (IOException e) {
            this.isFailed = true;
            if (e.getCause().getClass().getName().contains(ConfigException.class.getSimpleName())) {
                Throwable exception = e.getCause();
                this.logger.error("It appears that there is an error in your messages file! The error is: ");
                this.logger.error(exception.getMessage());
                this.logger.error("Please correct this then run /nucleus reload");
                this.logger.error("Ignoring messages.conf for now.");
                exception.printStackTrace();
            }
            this.logger.warn("Could not load custom messages file. Falling back.");
            e.printStackTrace();
        }
        if (firstLoad) {
            this.node.mergeValuesFrom((ConfigurationNode)this.getDefaults());
            this.fixMismatched(this.walkThroughForMismatched());
            this.save();
        }
    }

    private void save() {
        try {
            this.getLoader(this.file).save((ConfigurationNode)this.node);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

