/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.shops;

import com.erigitic.config.AccountManager;
import com.erigitic.config.TEAccount;
import com.erigitic.main.TotalEconomy;
import com.erigitic.shops.PlayerShopInfo;
import com.erigitic.shops.Shop;
import com.erigitic.shops.ShopItem;
import com.erigitic.shops.data.PlayerShopInfoData;
import com.erigitic.shops.data.ShopKeys;
import com.erigitic.util.MessageManager;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.block.tileentity.carrier.Chest;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.filter.type.Exclude;
import org.spongepowered.api.event.item.inventory.ClickInventoryEvent;
import org.spongepowered.api.event.item.inventory.InteractInventoryEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.entity.Hotbar;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.inventory.type.GridInventory;
import org.spongepowered.api.service.economy.account.Account;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.util.blockray.BlockRayHit;
import org.spongepowered.api.world.Location;

public class ShopManager {
    private TotalEconomy totalEconomy;
    private AccountManager accountManager;
    private MessageManager messageManager;
    private final double minPrice;
    private final double maxPrice;
    private final double chestShopPrice;

    public ShopManager(TotalEconomy totalEconomy, AccountManager accountManager, MessageManager messageManager) {
        this.totalEconomy = totalEconomy;
        this.accountManager = accountManager;
        this.messageManager = messageManager;
        this.minPrice = this.totalEconomy.getShopNode().getNode(new Object[]{"min-item-price"}).getDouble(0.0);
        this.maxPrice = this.totalEconomy.getShopNode().getNode(new Object[]{"max-item-price"}).getDouble(1.0E9);
        this.chestShopPrice = this.totalEconomy.getShopNode().getNode(new Object[]{"chestshop", "price"}).getDouble(1000.0);
    }

    @Listener
    @Exclude(value={ClickInventoryEvent.Shift.class})
    public void onItemPurchase(ClickInventoryEvent.Primary event, @First Player player, @Getter(value="getTargetInventory") Inventory inventory) {
        Optional shopOpt;
        Location location;
        Optional tileEntityOpt;
        Optional playerShopInfoOpt = player.get(ShopKeys.PLAYER_SHOP_INFO);
        if (playerShopInfoOpt.isPresent() && (tileEntityOpt = (location = ((PlayerShopInfo)playerShopInfoOpt.get()).getOpenShopLocation()).getTileEntity()).isPresent() && (shopOpt = ((TileEntity)tileEntityOpt.get()).get(ShopKeys.SINGLE_SHOP)).isPresent()) {
            Shop shop = (Shop)shopOpt.get();
            ItemStack clickedItem = ItemStack.builder().fromSnapshot((ItemStackSnapshot)((ItemStackSnapshot)event.getCursorTransaction().getDefault()).copy()).build();
            Optional shopItemOpt = clickedItem.get(ShopKeys.SHOP_ITEM);
            if (shopItemOpt.isPresent()) {
                event.getCursorTransaction().setValid(false);
                ShopItem shopItem = (ShopItem)shopItemOpt.get();
                TEAccount ownerAccount = (TEAccount)this.accountManager.getOrCreateAccount(shop.getOwner()).get();
                TEAccount customerAccount = (TEAccount)this.accountManager.getOrCreateAccount(player.getUniqueId()).get();
                if (customerAccount.getBalance(this.totalEconomy.getDefaultCurrency()).doubleValue() >= shopItem.getPrice()) {
                    ItemStack purchasedItem = this.removeShopItemData(clickedItem.copy());
                    Collection rejectedItems = player.getInventory().query(new QueryOperation[]{QueryOperationTypes.INVENTORY_TYPE.of(GridInventory.class), QueryOperationTypes.INVENTORY_TYPE.of(Hotbar.class)}).offer(purchasedItem).getRejectedItems();
                    if (rejectedItems.size() == 0) {
                        customerAccount.transfer((Account)ownerAccount, this.totalEconomy.getDefaultCurrency(), BigDecimal.valueOf(shopItem.getPrice()), event.getCause());
                        Slot clickedSlot = ((SlotTransaction)event.getTransactions().get(0)).getSlot();
                        this.updateItemInSlot(clickedSlot, clickedItem, clickedItem.getQuantity() - 1);
                    } else {
                        ((SlotTransaction)event.getTransactions().get(0)).setValid(false);
                        player.sendMessage(this.messageManager.getMessage("shops.purchase.noroom"));
                    }
                } else {
                    ((SlotTransaction)event.getTransactions().get(0)).setValid(false);
                    player.sendMessage(this.messageManager.getMessage("shops.purchase.insufficientfunds"));
                }
            } else {
                event.getCursorTransaction().setValid(false);
                this.invalidateTransactions(event.getTransactions());
            }
        }
    }

    @Listener
    @Exclude(value={ClickInventoryEvent.Shift.class})
    public void onShopSecondaryClick(ClickInventoryEvent.Secondary event, @First Player player) {
        Optional shopOpt;
        Location location;
        Optional tileEntityOpt;
        Optional playerShopInfoOpt = player.get(ShopKeys.PLAYER_SHOP_INFO);
        if (playerShopInfoOpt.isPresent() && (tileEntityOpt = (location = ((PlayerShopInfo)player.get(ShopKeys.PLAYER_SHOP_INFO).get()).getOpenShopLocation()).getTileEntity()).isPresent() && (shopOpt = ((TileEntity)tileEntityOpt.get()).get(ShopKeys.SINGLE_SHOP)).isPresent()) {
            this.invalidateTransactions(event.getTransactions());
            event.setCancelled(true);
        }
    }

    @Listener
    public void onShiftClickInventory(ClickInventoryEvent.Shift event, @First Player player, @Getter(value="getTargetInventory") Inventory inventory) {
        Optional shopOpt;
        Location location;
        Optional tileEntityOpt;
        Optional playerShopInfoOpt = player.get(ShopKeys.PLAYER_SHOP_INFO);
        if (playerShopInfoOpt.isPresent() && (tileEntityOpt = (location = ((PlayerShopInfo)player.get(ShopKeys.PLAYER_SHOP_INFO).get()).getOpenShopLocation()).getTileEntity()).isPresent() && (shopOpt = ((TileEntity)tileEntityOpt.get()).get(ShopKeys.SINGLE_SHOP)).isPresent()) {
            Shop shop = (Shop)shopOpt.get();
            ItemStack clickedItem = ItemStack.builder().fromSnapshot((ItemStackSnapshot)((SlotTransaction)event.getTransactions().get(0)).getOriginal()).build();
            Optional shopItemOpt = clickedItem.get(ShopKeys.SHOP_ITEM);
            if (player.getUniqueId().equals(shop.getOwner()) && shopItemOpt.isPresent()) {
                for (SlotTransaction transaction : event.getTransactions()) {
                    transaction.setCustom(ItemStack.empty());
                }
                ItemStack returnedItem = this.removeShopItemData(clickedItem.copy());
                returnedItem.setQuantity(clickedItem.getQuantity());
                player.getInventory().offer(returnedItem);
            } else if (player.getUniqueId().equals(shop.getOwner())) {
                event.setCancelled(false);
            } else if (shopItemOpt.isPresent()) {
                ShopItem shopItem = (ShopItem)shopItemOpt.get();
                int purchasedQuantity = clickedItem.getQuantity();
                TEAccount ownerAccount = (TEAccount)this.accountManager.getOrCreateAccount(shop.getOwner()).get();
                TEAccount customerAccount = (TEAccount)this.accountManager.getOrCreateAccount(player.getUniqueId()).get();
                if (customerAccount.getBalance(this.totalEconomy.getDefaultCurrency()).doubleValue() >= (double)purchasedQuantity * shopItem.getPrice()) {
                    ItemStack purchasedItem = this.removeShopItemData(clickedItem.copy());
                    purchasedItem.setQuantity(purchasedQuantity);
                    Collection rejectedItems = player.getInventory().query(new QueryOperation[]{QueryOperationTypes.INVENTORY_TYPE.of(GridInventory.class), QueryOperationTypes.INVENTORY_TYPE.of(Hotbar.class)}).offer(purchasedItem).getRejectedItems();
                    if (rejectedItems.size() == 0) {
                        for (SlotTransaction transaction : event.getTransactions()) {
                            transaction.setCustom(ItemStack.empty());
                        }
                        customerAccount.transfer((Account)ownerAccount, this.totalEconomy.getDefaultCurrency(), BigDecimal.valueOf((double)purchasedQuantity * shopItem.getPrice()), event.getCause());
                        player.getInventory().offer(purchasedItem);
                    } else {
                        ((SlotTransaction)event.getTransactions().get(0)).setValid(false);
                        player.sendMessage(this.messageManager.getMessage("shops.purchase.noroom"));
                    }
                } else {
                    this.invalidateTransactions(event.getTransactions());
                    player.sendMessage(this.messageManager.getMessage("shops.purchase.insufficientfunds"));
                }
            }
        }
    }

    @Listener
    public void onInventoryNumberPress(ClickInventoryEvent.NumberPress event, @First Player player) {
        Optional shopOpt;
        Location location;
        Optional tileEntityOpt;
        Optional playerShopInfoOpt = player.get(ShopKeys.PLAYER_SHOP_INFO);
        if (playerShopInfoOpt.isPresent() && (tileEntityOpt = (location = ((PlayerShopInfo)player.get(ShopKeys.PLAYER_SHOP_INFO).get()).getOpenShopLocation()).getTileEntity()).isPresent() && (shopOpt = ((TileEntity)tileEntityOpt.get()).get(ShopKeys.SINGLE_SHOP)).isPresent()) {
            event.setCancelled(true);
        }
    }

    @Listener
    public void onInventoryOpen(InteractInventoryEvent.Open event, @First Player player) {
        BlockSnapshot blockSnapshot;
        Optional shopOpt;
        Optional blockSnapshotOpt = event.getCause().getContext().get(EventContextKeys.BLOCK_HIT);
        if (blockSnapshotOpt.isPresent() && (shopOpt = (blockSnapshot = (BlockSnapshot)blockSnapshotOpt.get()).get(ShopKeys.SINGLE_SHOP)).isPresent()) {
            player.offer((ValueContainer)new PlayerShopInfoData(new PlayerShopInfo((Location)blockSnapshot.getLocation().get())));
        }
    }

    @Listener
    public void onInventoryClose(InteractInventoryEvent.Close event, @First Player player) {
        Optional playerShopInfoOpt = player.get(ShopKeys.PLAYER_SHOP_INFO);
        if (playerShopInfoOpt.isPresent()) {
            player.remove(ShopKeys.PLAYER_SHOP_INFO);
        }
    }

    @Listener
    public void onShopDestroy(ChangeBlockEvent.Pre event, @First Player player) {
        TileEntity tileEntity;
        Optional shopOpt;
        Optional tileEntityOpt = ((Location)event.getLocations().get(0)).getTileEntity();
        if (tileEntityOpt.isPresent() && (shopOpt = (tileEntity = (TileEntity)tileEntityOpt.get()).get(ShopKeys.SINGLE_SHOP)).isPresent()) {
            Chest chest = (Chest)tileEntity;
            Shop shop = (Shop)shopOpt.get();
            UUID shopOwner = shop.getOwner();
            if (!player.getUniqueId().equals(shopOwner)) {
                event.setCancelled(true);
                player.sendMessage(this.messageManager.getMessage("shops.remove.notowner"));
            } else if (player.getUniqueId().equals(shopOwner) && chest.getInventory().totalItems() > 0) {
                event.setCancelled(true);
                player.sendMessage(this.messageManager.getMessage("shops.remove.stocked"));
            } else {
                ((Location)event.getLocations().get(0)).removeBlock();
                ((Location)event.getLocations().get(0)).setBlockType(BlockTypes.CHEST);
            }
        }
    }

    @Listener
    public void onChestPlace(ChangeBlockEvent.Place event) {
        BlockSnapshot blockSnapshot = (BlockSnapshot)((Transaction)event.getTransactions().get(0)).getDefault();
        BlockType blockType = blockSnapshot.getState().getType();
        Location location = (Location)blockSnapshot.getLocation().get();
        if (blockType.equals(BlockTypes.CHEST) && this.isPlacedNextToShop(location)) {
            event.setCancelled(true);
        }
    }

    private ItemStack removeShopItemData(ItemStack itemStack) {
        itemStack.remove(Keys.ITEM_LORE);
        itemStack.remove(ShopKeys.SHOP_ITEM);
        DataContainer dataContainer = itemStack.toContainer().remove(DataQuery.of((String[])new String[]{"DefaultReplacement", "UnsafeData", "display", "Lore"})).copy();
        itemStack = ItemStack.builder().fromContainer((DataView)dataContainer).itemType(itemStack.getType()).quantity(1).build();
        return itemStack;
    }

    private boolean isPlacedNextToShop(Location location) {
        Optional westTileEntity;
        Optional southTileEntity;
        Optional eastTileEntity;
        boolean isPlacedNextToShop = false;
        Optional northTileEntity = location.getBlockRelative(Direction.NORTH).getTileEntity();
        if (northTileEntity.isPresent()) {
            isPlacedNextToShop = ((TileEntity)northTileEntity.get()).get(ShopKeys.SINGLE_SHOP).isPresent();
        }
        if ((eastTileEntity = location.getBlockRelative(Direction.EAST).getTileEntity()).isPresent()) {
            isPlacedNextToShop = ((TileEntity)eastTileEntity.get()).get(ShopKeys.SINGLE_SHOP).isPresent();
        }
        if ((southTileEntity = location.getBlockRelative(Direction.SOUTH).getTileEntity()).isPresent()) {
            isPlacedNextToShop = ((TileEntity)southTileEntity.get()).get(ShopKeys.SINGLE_SHOP).isPresent();
        }
        if ((westTileEntity = location.getBlockRelative(Direction.WEST).getTileEntity()).isPresent()) {
            isPlacedNextToShop = ((TileEntity)westTileEntity.get()).get(ShopKeys.SINGLE_SHOP).isPresent();
        }
        return isPlacedNextToShop;
    }

    private void updateItemInSlot(Slot slot, ItemStack itemStack, int quantity) {
        if (quantity == 0) {
            this.clearSlot(slot);
        } else {
            ItemStack itemStackCopy = itemStack.copy();
            itemStackCopy.setQuantity(quantity);
            slot.offer(itemStackCopy);
        }
    }

    private void clearSlot(Slot slot) {
        slot.set(ItemStack.empty());
    }

    private void invalidateTransactions(List<SlotTransaction> transactions) {
        for (SlotTransaction transaction : transactions) {
            transaction.setValid(false);
        }
    }

    public Optional<TileEntity> getTileEntityFromPlayerRaycast(Player player) {
        Optional optHit = BlockRay.from((Entity)player).skipFilter(BlockRay.blockTypeFilter((BlockType)BlockTypes.CHEST)).distanceLimit(3.0).build().end();
        if (optHit.isPresent()) {
            return ((BlockRayHit)optHit.get()).getLocation().getTileEntity();
        }
        return Optional.empty();
    }

    public double getMinPrice() {
        return this.minPrice;
    }

    public double getMaxPrice() {
        return this.maxPrice;
    }

    public double getChestShopPrice() {
        return this.chestShopPrice;
    }
}

