/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.modconfig;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.text.WordUtils;
import wanion.lib.module.AbstractModule;
import wanion.unidict.UniDict;
import wanion.unidict.common.Reference;
import wanion.unidict.modconfig.AbstractModConfigThread;
import wanion.unidict.modconfig.NuclearCraftModConfig;
import wanion.unidict.modconfig.TConstructModConfig;

public class ModConfigModule
extends AbstractModule
implements UniDict.IDependency {
    public ModConfigModule() {
        super("Mod Config", Class::newInstance);
    }

    public static ModConfigModule getModConfigModule() {
        return (ModConfigModule)UniDict.getDependencies().get(ModConfigModule.class);
    }

    protected void init() {
        Configuration config = new Configuration(new File("." + Reference.SLASH + "config" + Reference.SLASH + "unidict" + Reference.SLASH + "ModConfigModule.cfg"));
        for (ModConfig integration : ModConfig.values()) {
            String configName = WordUtils.capitalizeFully((String)integration.name().replace("_", ""));
            if (!config.get("ModConfigs", configName, true).getBoolean() || !Loader.isModLoaded((String)integration.modId)) continue;
            this.manager.add(integration.modConfigClass);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static enum ModConfig {
        NUCLEARCRAFT("nuclearcraft", NuclearCraftModConfig.class),
        TCONSTRUCT("tconstruct", TConstructModConfig.class);

        private final String modId;
        private final Class<? extends AbstractModConfigThread> modConfigClass;

        private ModConfig(String modId, Class<? extends AbstractModConfigThread> modConfigClass) {
            this.modId = modId;
            this.modConfigClass = modConfigClass;
        }
    }
}

