/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.facet;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.platform.AudienceProvider;
import net.kyori.adventure.platform.facet.FacetAudience;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class FacetAudienceProvider<V, A extends FacetAudience<V>>
implements AudienceProvider,
ForwardingAudience {
    private final Audience console;
    private final Audience player;
    private final Map<V, A> viewers = new ConcurrentHashMap<V, A>();
    private final Map<UUID, A> players = new ConcurrentHashMap<UUID, A>();
    private final Set<A> consoles = new CopyOnWriteArraySet<A>();
    private final A empty;
    private volatile boolean closed = false;

    public FacetAudienceProvider() {
        this.console = Audience.audience(this.consoles);
        this.player = Audience.audience(this.players.values());
        this.empty = this.createAudience(Collections.emptyList());
    }

    public void addViewer(@NonNull V viewer) {
        if (this.closed) {
            return;
        }
        FacetAudience audience = this.viewers.computeIfAbsent((FacetAudience)Objects.requireNonNull(viewer, "viewer"), (Function<FacetAudience, A>)((Function<Object, FacetAudience>)v -> this.createAudience(Collections.singletonList(v))));
        UUID playerId = this.hasId(viewer);
        if (playerId != null) {
            this.players.putIfAbsent(playerId, audience);
        } else if (this.isConsole(viewer)) {
            this.consoles.add(audience);
        }
    }

    public void removeViewer(@NonNull V viewer) {
        FacetAudience audience = (FacetAudience)this.viewers.remove(viewer);
        if (audience == null) {
            return;
        }
        UUID playerId = this.hasId(viewer);
        if (playerId != null) {
            this.players.remove(playerId);
        } else if (this.isConsole(viewer)) {
            this.consoles.remove(audience);
        }
        audience.close();
    }

    public void changeViewer(@NonNull V viewer, @NonNull Locale locale) {
        FacetAudience audience = (FacetAudience)this.viewers.get(viewer);
        if (audience != null) {
            audience.changeLocale(locale);
        }
    }

    protected abstract @Nullable UUID hasId(@NonNull V var1);

    protected abstract boolean isConsole(@NonNull V var1);

    protected abstract boolean hasPermission(@NonNull V var1, @NonNull String var2);

    protected abstract boolean isInWorld(@NonNull V var1, @NonNull Key var2);

    protected abstract boolean isOnServer(@NonNull V var1, @NonNull String var2);

    protected abstract @NonNull A createAudience(@NonNull Collection<V> var1);

    public @NonNull Iterable<? extends Audience> audiences() {
        return this.viewers.values();
    }

    @Override
    public @NonNull Audience all() {
        return this;
    }

    @Override
    public @NonNull Audience console() {
        return this.console;
    }

    @Override
    public @NonNull Audience players() {
        return this.player;
    }

    @Override
    public @NonNull Audience player(@NonNull UUID playerId) {
        return (Audience)this.players.getOrDefault(playerId, this.empty);
    }

    public @NonNull Audience filter(@NonNull Predicate<V> predicate) {
        return Audience.audience(FacetAudienceProvider.filter(this.viewers.entrySet(), entry -> predicate.test(entry.getKey()), Map.Entry::getValue));
    }

    @Override
    public @NonNull Audience permission(@NonNull String permission) {
        return this.filter(viewer -> this.hasPermission(viewer, permission));
    }

    @Override
    public @NonNull Audience world(@NonNull Key world) {
        return this.filter(viewer -> this.isInWorld(viewer, world));
    }

    @Override
    public @NonNull Audience server(@NonNull String serverName) {
        return this.filter(viewer -> this.isOnServer(viewer, serverName));
    }

    @Override
    public void close() {
        this.closed = true;
        for (V viewer : this.viewers.keySet()) {
            this.removeViewer(viewer);
        }
    }

    private static <T, V> @NonNull Iterable<V> filter(final @NonNull Iterable<T> input, final @NonNull Predicate<T> filter, final @NonNull Function<T, V> transformer) {
        return new Iterable<V>(){

            @Override
            public @NonNull Iterator<V> iterator() {
                return new Iterator<V>(){
                    private final Iterator<T> parent;
                    private V next;
                    {
                        this.parent = input.iterator();
                        this.populate();
                    }

                    private void populate() {
                        this.next = null;
                        while (this.parent.hasNext()) {
                            Object next = this.parent.next();
                            if (!filter.test(next)) continue;
                            this.next = transformer.apply(next);
                            return;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public V next() {
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                        Object next = this.next;
                        this.populate();
                        return next;
                    }
                };
            }

            @Override
            public void forEach(Consumer<? super V> action) {
                for (Object each : input) {
                    if (!filter.test(each)) continue;
                    action.accept(transformer.apply(each));
                }
            }
        };
    }
}

